<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'init', 'client_faq' );

function client_faq() {
	$labels = array(
		'name'               => _x( 'FAQ', 'post type general name', 'asdesign' ),
		'singular_name'      => _x( 'FAQ', 'post type singular name', 'asdesign' ),
		'menu_name'          => _x( 'FAQ', 'admin menu', 'asdesign' ),
		'name_admin_bar'     => _x( 'FAQ', 'add new on admin bar', 'asdesign' ),
		'add_new'            => _x( 'Add New', 'FAQ', 'asdesign' ),
		'add_new_item'       => __( 'Add New FAQ', 'asdesign' ),
		'new_item'           => __( 'New FAQ', 'asdesign' ),
		'edit_item'          => __( 'Edit FAQ', 'asdesign' ),
		'view_item'          => __( 'View FAQ', 'asdesign' ),
		'all_items'          => __( 'All FAQ', 'asdesign' ),
		'search_items'       => __( 'Search FAQ', 'asdesign' ),
		'parent_item_colon'  => __( 'Parent FAQ:', 'asdesign' ),
		'not_found'          => __( 'No FAQ found.', 'asdesign' ),
		'not_found_in_trash' => __( 'No FAQ found in Trash.', 'asdesign' )
	);
	$args = array(
		'labels'             => $labels,
        'description'        => __( '', 'asdesign' ),
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => false ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => true,
		'menu_position'      => null,
		'supports'           => array( 'title', 'editor', 'thumbnail', 'excerpt' ),
		// This is where we add taxonomies to our CPT
        //'taxonomies'          => array( 'category' ),
	);
	register_post_type( 'my_faq', $args );
	
	// Add new taxonomy, make it hierarchical (like categories)

        $cat_labels = array(
            'name'              => _x( 'FAQ Category', 'taxonomy general name' ),
            'singular_name'     => _x( 'FAQ Category', 'taxonomy singular name' ),
            'search_items'      =>  __( 'Search FAQ Category' ),
            'all_items'         => __( 'All FAQ Category' ),
            'parent_item'       => __( 'Parent FAQ Category' ),
            'parent_item_colon' => __( 'Parent FAQ Category:' ),
            'edit_item'         => __( 'Edit FAQ Category' ),
            'update_item'       => __( 'Update FAQ Category' ),
            'add_new_item'      => __( 'Add New FAQ Category' ),
            'new_item_name'     => __( 'New FAQ Category Name' ),
            'menu_name'         => __( 'FAQ Category' ),
        );

        register_taxonomy('faq-category',array('my_faq'), array(
		    'public' => true,
            'hierarchical' => true,
            'labels'       => $cat_labels,
            'show_ui'      => true,
            'query_var'    => true,
            'rewrite'      => array( 'slug' => false ),
			'show_admin_column' => true,

        ));

}
?>