<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'init', 'client_case_studies' );

function client_case_studies() {
	$labels = array(
		'name'               => _x( 'Case Studies', 'post type general name', 'asdesign' ),
		'singular_name'      => _x( 'Case Studies', 'post type singular name', 'asdesign' ),
		'menu_name'          => _x( 'Case Studies', 'admin menu', 'asdesign' ),
		'name_admin_bar'     => _x( 'Case Studies', 'add new on admin bar', 'asdesign' ),
		'add_new'            => _x( 'Add New', 'Case Studies', 'asdesign' ),
		'add_new_item'       => __( 'Add New Case Studies', 'asdesign' ),
		'new_item'           => __( 'New Case Studies', 'asdesign' ),
		'edit_item'          => __( 'Edit Case Studies', 'asdesign' ),
		'view_item'          => __( 'View Case Studies', 'asdesign' ),
		'all_items'          => __( 'All Case Studies', 'asdesign' ),
		'search_items'       => __( 'Search Case Studies', 'asdesign' ),
		'parent_item_colon'  => __( 'Parent Case Studies:', 'asdesign' ),
		'not_found'          => __( 'No Case Studies found.', 'asdesign' ),
		'not_found_in_trash' => __( 'No Case Studies found in Trash.', 'asdesign' )
	);
	$args = array(
		'labels'             => $labels,
        'description'        => __( '', 'asdesign' ),
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => false ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => true,
		'menu_position'      => null,
		'supports'           => array( 'title', 'editor', 'thumbnail', 'excerpt' )
	);
	register_post_type( 'my_case_studies', $args );
}



?>