document.addEventListener("DOMContentLoaded", () => {
  const prefersReduced = window.matchMedia("(prefers-reduced-motion: reduce)").matches;

  document.querySelectorAll(".theme_button").forEach(button => {
    // Prefer data-text, fallback to existing content
    let text = button.dataset.text;
    if (typeof text !== "string" || text.trim() === "") {
      text = button.textContent.trim();
      if (!text) return; // nothing to animate, skip
    }

    // Accessibility: keep full label for screen readers
    button.setAttribute("aria-label", text);

    // Rebuild per-character spans
    button.innerHTML = "";
    [...text].forEach((char, index) => {
      const span = document.createElement("span");
      span.textContent = char;
      span.style.transitionDelay = `${index * 45}ms`; // stagger
      button.appendChild(span);
    });

    if (prefersReduced) return; // skip hover logic if reduced motion

    button.addEventListener("mouseenter", () => {
      button.classList.add("animate");
    });
    button.addEventListener("mouseleave", () => {
      button.classList.remove("animate");
    });
  });
});

// fixed navbar
const navbar = document.querySelector(".navbar");
const navbarSpacer = document.querySelector(".navbar-spacer");
// const  topBar = document.querySelector(".top_bar");

window.addEventListener("scroll", () => {
  const shouldBeFixed = window.scrollY > 180;

  if (shouldBeFixed) {
    navbar.classList.add("fixed_nav");
    navbar.classList.add("scrolled_nav");
// 	  topBar.classList.add("d-none");
  } else {
    navbar.classList.remove("scrolled_nav");
    navbar.classList.remove("fixed_nav");
// 	   topBar.classList.remove("d-none");
  }
});
// hero h1 typewriter effect
 const words = [
    "Physiotherapy.",
    "Chiropractic Care.",
    "Massage Therapy.",
    "Acupuncture.",
    "Ayurveda.",
    "Custom Orthotics.",
	"Naturopathic Treatment."
  ];

  let i = 0;
  let j = 0;
  let currentWord = "";
  let isDeleting = false;

  const el = document.querySelector(".typewriter-text");
  const cursor = document.querySelector(".cursor");

  if (el && cursor) {
    el.textContent = ""; // Clear fallback text

    function type() {
      currentWord = words[i];

      // While typing, hide the blinking cursor
      cursor.style.opacity = 0;

      if (!isDeleting) {
        el.textContent = currentWord.substring(0, j + 1);
        j++;

        if (j === currentWord.length) {
          isDeleting = true;
          cursor.style.opacity = 1; // Show cursor after word completes
          setTimeout(type, 1500);
          return;
        }
      } else {
        el.textContent = currentWord.substring(0, j - 1);
        j--;

        if (j === 0) {
          isDeleting = false;
          i = (i + 1) % words.length;
        }
      }

      setTimeout(type, isDeleting ? 60 : 100);
    }

    document.addEventListener("DOMContentLoaded", type);
}

  // owl sliders
$(document).ready(function(){
    // service slider
  $(".services_slider .owl-carousel").owlCarousel({
  	loop:true,
    margin:10,
    nav:true,
	autoplay:false,
    autoplayTimeout:3000,
    autoplayHoverPause:true,
    center: true,
    navText: [
	    "<i class='fa fa-angle-left'></i>",
	    "<i class='fa fa-angle-right'></i>"
	],
    responsive:{
        0:{
            items:1
        },
        600:{
            items:1
        },
        1000:{
            items:3
        }
    }
  });
  // condition slider
  $(".condition_slider .owl-carousel").owlCarousel({
  	loop:true,
    margin:10,
    nav:true,
	autoplay:false,
    autoplayTimeout:3000,
    autoplayHoverPause:true,
    center: true,
    navText: [
	    "<i class='fa fa-angle-left'></i>",
	    "<i class='fa fa-angle-right'></i>"
	],
    responsive:{
        0:{
            items:1,
			dots: false
        },
        600:{
            items:1,
			dots: false
        },
        1000:{
            items:3
        }
    }
  });
  //team slider
  $(".team_slider .owl-carousel").owlCarousel({
    loop: true,
    margin: 20,
    nav: false,
    dots: true,
    autoplay: false,
    navText: ["&#9664;", "&#9654;"],
    autoplayTimeout: 3000,
    autoplayHoverPause: true,
    responsive: {
      0: { items: 1 },
      600: { items: 2 },
      1000: { items: 4 },
    },
  });
});

// sticky aside
